implementation module timeraccess


//	Clean Object I/O library, version 1.0.1


import StdTuple
import timertable, timerhandle, devicesystemstate, commondef


timeraccessError :: String String -> .x
timeraccessError function error = Error function "timeraccess" error


disposeReceiverTableEntries :: !(TimerElementHandle .ls .ps) !ReceiverTable -> ReceiverTable
disposeReceiverTableEntries (TimerReceiverHandle {tReceiverHandle={rId}}) rt
	= snd (removeReceiverFromReceiverTable rId rt)
disposeReceiverTableEntries (TimerListLSHandle tListItems) rt
	= StateMap2 disposeReceiverTableEntries tListItems rt
disposeReceiverTableEntries (TimerElimLSHandle tElimItems) rt
	= StateMap2 disposeReceiverTableEntries tElimItems rt
disposeReceiverTableEntries (TimerIntroLSHandle {tIntroItems}) rt
	= StateMap2 disposeReceiverTableEntries tIntroItems rt
disposeReceiverTableEntries (TimerExtendLSHandle {tExtendItems}) rt
	= StateMap2 disposeReceiverTableEntries tExtendItems rt
disposeReceiverTableEntries (TimerChangeLSHandle {tChangeItems}) rt
	= StateMap2 disposeReceiverTableEntries tChangeItems rt
disposeReceiverTableEntries _ rt
	= rt

disposeTimerTableEntries :: !SystemId !(TimerElementHandle .ls .ps) !TimerTable -> TimerTable
disposeTimerTableEntries pid (TimerReceiverHandle {tReceiverHandle={rId}}) tt
	= snd (removeTimerFromTimerTable teLoc tt)
where
	teLoc	= {tlIOId=pid,tlDevice=TimerDevice,tlParentId=rId,tlTimerId=rId}
disposeTimerTableEntries pid (TimerListLSHandle tListItems) tt
	= StateMap2 (disposeTimerTableEntries pid) tListItems tt
disposeTimerTableEntries pid (TimerElimLSHandle tElimItems) tt
	= StateMap2 (disposeTimerTableEntries pid) tElimItems tt
disposeTimerTableEntries pid (TimerIntroLSHandle {tIntroItems}) tt
	= StateMap2 (disposeTimerTableEntries pid) tIntroItems tt
disposeTimerTableEntries pid (TimerExtendLSHandle {tExtendItems}) tt
	= StateMap2 (disposeTimerTableEntries pid) tExtendItems tt
disposeTimerTableEntries pid (TimerChangeLSHandle {tChangeItems}) tt
	= StateMap2 (disposeTimerTableEntries pid) tChangeItems tt
disposeTimerTableEntries _ _ tt
	= tt

identifyTimerStateHandle :: !Id !(TimerStateHandle .ps) -> (!Bool,!TimerStateHandle .ps)
identifyTimerStateHandle id tlsH=:(TimerLSHandle {tHandle={tId}})
	= (id==tId,tlsH)

TimerSystemStateGetTimerHandles :: !(DeviceSystemState .ps) -> TimerHandles .ps
TimerSystemStateGetTimerHandles (TimerSystemState tHs)
	= tHs
TimerSystemStateGetTimerHandles _
	= timeraccessError "TimerSystemStateGetTimerHandles" "argument is no TimerSystemState"
